<?php
require 'db.php';

// Log the webhook data
$webhook_data = file_get_contents('php://input');
$log_file = 'webhook_log.txt';
file_put_contents($log_file, date('Y-m-d H:i:s') . " - " . $webhook_data . "\n", FILE_APPEND);

// Parse the webhook data
$data = json_decode($webhook_data, true);

if ($data) {
    $order_id = $data['merchantOrderId'] ?? '';
    $status = $data['status'] ?? '';
    $amount = $data['amount'] ?? 0;
    
    // Extract user_id from order_id (assuming format: date + time + random + user_id)
    // You might need to adjust this based on your actual order_id format
    $user_id = substr($order_id, -1); // Simple extraction, adjust as needed
    
    if ($status == '200' || $status == 'success') {
        // Payment successful - update user balance
        $update_query = "UPDATE users SET balance = balance + ? WHERE id = ?";
        $stmt = $conn->prepare($update_query);
        $stmt->bind_param("di", $amount, $user_id);
        
        if ($stmt->execute()) {
            // Update recharge status to completed
            $update_recharge = "UPDATE recharges SET status = 'completed' WHERE user_id = ? AND amount = ? ORDER BY created_at DESC LIMIT 1";
            $stmt2 = $conn->prepare($update_recharge);
            $stmt2->bind_param("id", $user_id, $amount);
            $stmt2->execute();
            
            echo "SUCCESS";
        } else {
            echo "ERROR: Failed to update balance";
        }
    } else {
        // Payment failed
        $update_recharge = "UPDATE recharges SET status = 'failed' WHERE user_id = ? AND amount = ? ORDER BY created_at DESC LIMIT 1";
        $stmt = $conn->prepare($update_recharge);
        $stmt->bind_param("id", $user_id, $amount);
        $stmt->execute();
        
        echo "FAILED";
    }
} else {
    echo "INVALID_DATA";
}

$conn->close();
?>